<?php
header('Content-Type: text/html; charset=utf-8');
session_start();
// Verificar si el usuario está autenticado, si no lo está, redirigirlo a la página de inicio de sesión
if (!isset($_SESSION['autenticado']) || $_SESSION['autenticado'] !== true) {
    header("Location: login.php");
    exit;
}

require 'vendor/autoload.php'; // Asegúrate de cargar el archivo autoload.php de Composer

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Función para crear botones
function crearBoton($url, $texto, $color)
{
    echo '<a href="' . $url . '" style="padding: 10px 20px; background-color: ' . $color . '; color: #fff; text-decoration: none; border-radius: 5px; margin-right: 10px;">' . $texto . '</a>';
}

// Mostrar botones
echo '<div style="text-align: center; margin-bottom: 60px; margin-top: 60px;">'; // Modificación en el margen superior aquí
crearBoton('https://politecnicodecolombia.co/respaldo/consulta.php', 'Nueva Consulta', '#332508');
crearBoton('#', 'Servidor2', '#e7be64');
crearBoton('https://politecnicodecolombia.co', 'Salir', '#db7122');
echo '</div>';

// Verificar si se han enviado parámetros por POST
if (isset($_POST['inicio']) && isset($_POST['fin'])) {
    // Obtener los valores enviados por el usuario
    $inicio = $_POST['inicio'];
    $fin = $_POST['fin'];

    // Conexión a la base de datos
    $db = new PDO('mysql:host=localhost;dbname=polimoodle_moodle', 'polimoodle_respaldo', 'Zp3ctrum24++');

    // Preparar la consulta con parámetros dinámicos
    $sql = "SELECT u.firstname AS 'Nombres', u.lastname AS 'Apellidos', u.username AS 'Documento', u.email AS 'Correo', c.fullname AS 'Diplomado', cc.name AS 'Centro', CASE WHEN gi.itemtype = 'course' THEN c.fullname + ' Course Total' ELSE gi.itemname END AS 'Actividad', ROUND(gg.finalgrade,2) AS Nota 
            FROM mdl_course AS c 
            JOIN mdl_context AS ctx ON c.id = ctx.instanceid 
            JOIN mdl_role_assignments AS ra ON ra.contextid = ctx.id 
            JOIN mdl_user AS u ON u.id = ra.userid 
            JOIN mdl_grade_grades AS gg ON gg.userid = u.id 
            JOIN mdl_grade_items AS gi ON gi.id = gg.itemid 
            JOIN mdl_course_categories as cc ON cc.id = c.category 
            WHERE gi.courseid = c.id AND cc.name BETWEEN :inicio AND :fin 
            ORDER BY 'Nombres' ASC"; // Quitamos la cláusula LIMIT para obtener todos los datos

    // Preparar la consulta con parámetros
    $stmt = $db->prepare($sql);
    // Asignar los valores de los parámetros
    $stmt->bindParam(':inicio', $inicio, PDO::PARAM_STR);
    $stmt->bindParam(':fin', $fin, PDO::PARAM_STR);
    // Ejecutar la consulta
    $stmt->execute();

    // Obtener todos los resultados
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Contar el número total de estudiantes
    $totalEstudiantes = count($resultados);

    // Contadores para los resultados mayores e iguales a 60, iguales a 0 y menores o iguales a 59
    $mayorIgual60 = 0;
    $igual0 = 0;
    $menorIgual59 = 0;

    // Iterar sobre los resultados para contar cuántos son mayores e iguales a 60, iguales a 0 y cuántos son menores o iguales a 59
    foreach ($resultados as $fila) {
        if ($fila['Nota'] >= 60) {
            $mayorIgual60++;
        } elseif ($fila['Nota'] == 0 || $fila['Nota'] == '') { // Modificación para contar notas cero y vacías como un solo resultado
            $igual0++;
        } else {
            $menorIgual59++;
        }
    }

    // Mostrar el número total de estudiantes
    echo "<p>Total de estudiantes: $totalEstudiantes</p>";

    // Mostrar el número de resultados mayores e iguales a 60, iguales a 0 y menores o iguales a 59
    echo "<p>Número de estudiantes que aprobaron: $mayorIgual60</p>";
    echo "<p>Número de estudiantes que perdieron: $menorIgual59</p>";
    echo "<p>Número de estudiante que no presentaron ninguna actividad: $igual0</p>";

    // Crear un nuevo objeto Spreadsheet
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Definir los encabezados con las modificaciones necesarias
    $headers = ['Nombres', 'Apellidos', 'Documento', 'Correo', 'Diplomado', 'Centro', 'Actividad', 'Nota'];
    $sheet->fromArray($headers, NULL, 'A1');

    // Insertar todos los datos en el archivo de Excel con las modificaciones necesarias
    $row = 2;
    foreach ($resultados as $fila) {
        // Realizar las modificaciones necesarias en la columna "Actividad"
        $actividad = $fila['Actividad'];
        // Reemplazar "EVALUACI�N � M�DULO 1" por "EVALUACION MODULO 1"
       // $fila['Actividad'] = str_replace('EVALUACI�N � M�DULO 1', 'EVALUACION MODULO 1', $fila['Actividad']);
      //  $actividad = str_replace('EVALUACI�N', 'EVALUACION', $actividad);
       // $actividad = str_replace('� M�DULO 1', 'MODULO 1', $actividad);
        // Si la actividad es cero, reemplazar por "promedio"
        if ($actividad == '0') {
            $actividad = 'Promedio';
        }
        // Insertar la fila con las modificaciones
        $sheet->fromArray([$fila['Nombres'], $fila['Apellidos'], $fila['Documento'], $fila['Correo'], $fila['Diplomado'], $fila['Centro'], $actividad, $fila['Nota']], NULL, 'A' . $row);
        $row++;
    }

    // Guardar el archivo
    $nombreArchivo = 'reporte_' . date('Ymd_His') . '.xlsx';
    $writer = new Xlsx($spreadsheet);
    $writer->save($nombreArchivo);

    // Mostrar solo los primeros 30 datos en la tabla HTML
    $resultadosLimitados = array_slice($resultados, 0, 20);

    // Mostrar los resultados en la tabla HTML
    echo '<table border="1" style="border-collapse: collapse; width: 100%;">';
    echo '<tr style="background-color: #f2f2f2;"><th style="padding: 8px; text-align: left;">Nombres</th><th style="padding: 8px; text-align: left;">Apellidos</th><th style="padding: 8px; text-align: left;">Documento</th><th style="padding: 8px; text-align: left;">Correo</th><th style="padding: 8px; text-align: left;">Diplomado</th><th style="padding: 8px; text-align: left;">Centro</th><th style="padding: 8px; text-align: left;">Actividad</th><th style="padding: 8px; text-align: left;">Nota</th></tr>';
    foreach ($resultadosLimitados as $fila) {
        echo '<tr>';
        echo '<td style="padding: 8px;">' . $fila['Nombres'] . '</td>';
        echo '<td style="padding: 8px;">' . $fila['Apellidos'] . '</td>';
        echo '<td style="padding: 8px;">' . $fila['Documento'] . '</td>';
        echo '<td style="padding: 8px;">' . $fila['Correo'] . '</td>';
        echo '<td style="padding: 8px;">' . $fila['Diplomado'] . '</td>';
        echo '<td style="padding: 8px;">' . $fila['Centro'] . '</td>';
        echo '<td style="padding: 8px;">' . $fila['Actividad'] . '</td>';
        echo '<td style="padding: 8px;">' . $fila['Nota'] . '</td>';
        echo '</tr>';
    }
    echo '</table>';

    // Mostrar enlace para descargar el archivo de Excel
    echo '<div style="text-align: center; margin-top: 20px;">';
    echo '<a href="' . $nombreArchivo . '">Descargar archivo de Excel</a>';
    echo '</div>';
} else {
    // Formulario para que el usuario ingrese los valores de inicio y fin
    echo '<form method="post" action="" style="text-align: center;">';
    echo 'Centro Inicial: <input type="text" name="inicio" style="margin-right: 10px;" value="C">&nbsp;&nbsp;'; // Agrega el valor predeterminado "C"
    echo 'Centro Final: <input type="text" name="fin" value="C"><br><br>'; // Agrega el valor predeterminado "C"
    echo '<input type="submit" value="Consultar" style="margin-top: 10px; padding: 10px 20px; background-color: #007bff; color: #fff; border: none; border-radius: 5px; cursor: pointer;">';
    echo '</form>';
}
?>
